# OptiCore SaaS

Sistema de gestión multi-tenant para ópticas. Desarrollado en PHP 8.1 puro con arquitectura MVC personalizada y Bootstrap 5.3.

---

## Características

- **Multi-tenant**: Cada empresa tiene sus propios datos aislados
- **Roles y permisos granulares**: Sistema de permisos por módulo y acción
- **Gestión de pacientes y recetas ópticas**: OD/OI con todos los campos de graduación
- **POS (Punto de Venta)**: Carrito dinámico con múltiples métodos de pago
- **Control de stock**: Kardex, ajustes, alertas de stock mínimo
- **Caja**: Apertura/cierre con movimientos y cuadre
- **Reportes**: Ventas, stock e historial de caja con exportación CSV
- **SuperAdmin**: Gestión de empresas, planes y licencias SaaS

---

## Requisitos

| Componente | Versión mínima |
|------------|---------------|
| PHP        | 8.1           |
| MySQL      | 8.0           |
| Apache     | 2.4 (mod_rewrite) |
| MAMP / XAMPP | Cualquier versión reciente |

---

## Instalación

### 1. Clonar / copiar el proyecto

```bash
# Copiar la carpeta opticore/ dentro del directorio web de MAMP/XAMPP
# Ejemplo MAMP Windows:
C:\MAMP\htdocs\opticore\
```

### 2. Crear la base de datos

```sql
-- En phpMyAdmin o MySQL CLI:
SOURCE /ruta/a/opticore/database/schema.sql;
SOURCE /ruta/a/opticore/database/seeds.sql;
```

### 3. Configurar la conexión

Editar `config/database.php`:

```php
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'opticore');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### 4. Configurar la URL base

Editar `config/config.php`:

```php
// MAMP Windows puerto 80:
define('BASE_URL', 'http://localhost/opticore');

// MAMP puerto 8888:
define('BASE_URL', 'http://localhost:8888/opticore');
```

### 5. Configurar Apache (Virtual Host o .htaccess)

El archivo `public/.htaccess` ya está configurado. Asegúrate de que `mod_rewrite` esté habilitado.

Si usas MAMP, el Document Root debe apuntar a `opticore/public/` o acceder vía `http://localhost/opticore/public/`.

### 6. Permisos de directorios

```bash
chmod -R 755 opticore/
chmod -R 777 opticore/public/uploads/
chmod -R 777 opticore/storage/
```

---

## Credenciales por defecto

| Rol        | Email                    | Contraseña |
|------------|--------------------------|------------|
| SuperAdmin | superadmin@opticore.app  |password |
| Admin      | admin@demo.com           | password |
| Vendedor   | vendedor@demo.com        | password |

> ⚠️ **Cambiar las contraseñas inmediatamente en producción.**

---

## Estructura del Proyecto

```
opticore/
├── app/
│   ├── controllers/        # Controladores MVC
│   ├── helpers/            # Funciones globales, CSRF, permisos
│   ├── middleware/         # AuthMiddleware
│   ├── models/             # Modelos con lógica de negocio
│   └── views/              # Vistas PHP por módulo
│       ├── layouts/        # main.php, auth.php, print.php
│       ├── auth/
│       ├── dashboard/
│       ├── planes/
│       ├── empresas/
│       ├── licencias/
│       ├── sucursales/
│       ├── roles/
│       ├── usuarios/
│       ├── pacientes/
│       ├── recetas/
│       ├── productos/
│       ├── stock/
│       ├── ventas/
│       ├── caja/
│       └── reportes/
├── config/
│   ├── config.php          # Configuración principal
│   └── database.php        # Credenciales DB
├── database/
│   ├── schema.sql          # Estructura de tablas
│   └── seeds.sql           # Datos iniciales
├── public/
│   ├── assets/
│   │   ├── css/app.css     # Estilos personalizados
│   │   ├── js/app.js       # JavaScript global
│   │   └── uploads/        # Archivos subidos
│   ├── .htaccess           # Rewrite rules
│   └── index.php           # Front controller + Router
└── storage/                # Logs, caché
```

---

## Módulos

| Módulo       | Descripción                                          |
|--------------|------------------------------------------------------|
| Dashboard    | Estadísticas generales según rol                     |
| Planes       | Gestión de planes SaaS (solo SuperAdmin)             |
| Empresas     | Alta y configuración de empresas cliente             |
| Licencias    | Control de suscripciones y vencimientos              |
| Sucursales   | Gestión de sucursales por empresa                    |
| Roles        | Roles con permisos granulares por módulo             |
| Usuarios     | Gestión de usuarios con asignación de rol/sucursal   |
| Pacientes    | Ficha completa con historial de recetas y ventas     |
| Recetas      | Recetas ópticas OD/OI con impresión                  |
| Productos    | Catálogo con imagen, precios y stock mínimo          |
| Stock        | Control de inventario, ajustes y kardex              |
| Ventas       | POS con carrito, múltiples pagos e impresión         |
| Caja         | Apertura/cierre con movimientos y cuadre             |
| Reportes     | Ventas, stock y caja con filtros y exportación CSV   |

---

## Permisos disponibles

Los permisos siguen el patrón `modulo.accion`:

```
pacientes.ver, pacientes.crear, pacientes.editar, pacientes.eliminar
recetas.ver, recetas.crear, recetas.imprimir
productos.ver, productos.crear, productos.editar, productos.eliminar
stock.ver, stock.ajustar
ventas.ver, ventas.crear, ventas.anular
caja.ver, caja.abrir, caja.cerrar, caja.movimiento
reportes.ver
usuarios.ver, usuarios.crear, usuarios.editar
roles.ver, roles.crear, roles.editar
sucursales.ver, sucursales.crear, sucursales.editar
```

---

## Tecnologías

- **Backend**: PHP 8.1 (sin framework)
- **Frontend**: Bootstrap 5.3.3 + Bootstrap Icons 1.11.3
- **Base de datos**: MySQL 8.0 con PDO
- **Arquitectura**: MVC personalizado, multi-tenant por `empresa_id`
- **Seguridad**: CSRF tokens, bcrypt passwords, XSS escaping, session hardening

---

## Licencia

Uso interno / comercial. Todos los derechos reservados.
