<?php
/**
 * OptiCore SaaS - CSRF Protection Helper
 */

// ── Generar token CSRF ────────────────────────────────────────
function csrfToken(): string
{
    if (empty($_SESSION[CSRF_TOKEN_NAME])) {
        $_SESSION[CSRF_TOKEN_NAME] = bin2hex(random_bytes(32));
    }
    return $_SESSION[CSRF_TOKEN_NAME];
}

// ── Campo oculto CSRF para formularios ────────────────────────
function csrfField(): string
{
    return '<input type="hidden" name="' . CSRF_TOKEN_NAME . '" value="' . csrfToken() . '">';
}

// ── Verificar token CSRF ──────────────────────────────────────
function verifyCsrf(): void
{
    $token = $_POST[CSRF_TOKEN_NAME] ?? $_SERVER['HTTP_X_CSRF_TOKEN'] ?? '';

    if (empty($token) || !hash_equals($_SESSION[CSRF_TOKEN_NAME] ?? '', $token)) {
        http_response_code(419);
        if (isAjax()) {
            jsonResponse(['error' => 'Token CSRF inválido. Recarga la página.'], 419);
        }
        flash('error', 'Token de seguridad inválido. Por favor, intenta de nuevo.');
        redirect($_SERVER['HTTP_REFERER'] ?? '/');
    }

    // Regenerar token después de verificar (protección adicional)
    $_SESSION[CSRF_TOKEN_NAME] = bin2hex(random_bytes(32));
}

// ── Meta tag CSRF para AJAX ───────────────────────────────────
function csrfMeta(): string
{
    return '<meta name="csrf-token" content="' . csrfToken() . '">';
}

// ── Alias snake_case (usados en vistas y controladores) ───────
function csrf_field(): string  { return csrfField(); }
function csrf_verify(): void   { verifyCsrf(); }
function csrf_token(): string  { return csrfToken(); }
function csrf_meta(): string   { return csrfMeta(); }
