<?php
/**
 * OptiCore SaaS - Audit Log Model
 */

class AuditLog
{
    public static function log(
        string $accion,
        string $tabla = '',
        ?int $registroId = null,
        mixed $datosAnteriores = null,
        mixed $datosNuevos = null
    ): void {
        try {
            $db = db();
            $db->insert('audit_logs', [
                'empresa_id'       => Auth::empresaId(),
                'usuario_id'       => Auth::id(),
                'accion'           => $accion,
                'tabla'            => $tabla,
                'registro_id'      => $registroId,
                'datos_anteriores' => $datosAnteriores ? json_encode($datosAnteriores, JSON_UNESCAPED_UNICODE) : null,
                'datos_nuevos'     => $datosNuevos ? json_encode($datosNuevos, JSON_UNESCAPED_UNICODE) : null,
                'ip'               => clientIp(),
                'user_agent'       => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 300),
                'fecha'            => date('Y-m-d H:i:s'),
            ]);
        } catch (Exception $e) {
            // No interrumpir el flujo si falla el log
            error_log('AuditLog error: ' . $e->getMessage());
        }
    }

    public static function getByEmpresa(int $empresaId, int $limit = 100): array
    {
        return db()->fetchAll(
            "SELECT al.*, CONCAT(u.nombre, ' ', u.apellido) as usuario_nombre
             FROM audit_logs al
             LEFT JOIN usuarios u ON al.usuario_id = u.id
             WHERE al.empresa_id = ?
             ORDER BY al.fecha DESC
             LIMIT ?",
            [$empresaId, $limit]
        );
    }
}
