<?php
/**
 * OptiCore SaaS - Categoria Model
 */

class Categoria extends BaseModel
{
    protected string $table = 'categorias';

    public function getAll(int $page = 1, string $search = ''): array
    {
        $params = [$this->empresaScope()];
        $where  = 'empresa_id = ?';

        if ($search) {
            $where   .= ' AND nombre LIKE ?';
            $params[] = "%$search%";
        }

        $sql = "SELECT * FROM `{$this->table}` WHERE $where ORDER BY nombre ASC";
        return $this->db->paginate($sql, $params, $page);
    }

    public function getActivas(): array
    {
        return $this->db->fetchAll(
            "SELECT * FROM `{$this->table}` WHERE empresa_id = ? AND estado = 'activa' ORDER BY nombre",
            [$this->empresaScope()]
        );
    }

    public function getById(int $id): array|false
    {
        return $this->db->fetchOne(
            "SELECT * FROM `{$this->table}` WHERE id = ? AND empresa_id = ?",
            [$id, $this->empresaScope()]
        );
    }

    public function crear(array $data): int
    {
        return $this->db->insert($this->table, [
            'empresa_id'  => $this->empresaScope(),
            'nombre'      => trim($data['nombre']),
            'descripcion' => trim($data['descripcion'] ?? '') ?: null,
            'estado'      => $data['estado'] ?? 'activa',
        ]);
    }

    public function actualizar(int $id, array $data): int
    {
        return $this->update($id, [
            'nombre'      => trim($data['nombre']),
            'descripcion' => trim($data['descripcion'] ?? '') ?: null,
            'estado'      => $data['estado'] ?? 'activa',
        ]);
    }

    public function eliminar(int $id): int
    {
        return $this->update($id, ['estado' => 'inactiva']);
    }

    public function tieneProductos(int $id): bool
    {
        return (bool) $this->db->fetchColumn(
            "SELECT COUNT(*) FROM productos WHERE categoria_id = ? AND empresa_id = ?",
            [$id, $this->empresaScope()]
        );
    }
}
