<?php
/**
 * OptiCore SaaS - Empresa Model
 */

class Empresa extends BaseModel
{
    protected string $table = 'empresas';

    public function getAll(int $page = 1, string $search = ''): array
    {
        $params = [];
        $where  = '1=1';
        if ($search) {
            $where   .= ' AND (e.nombre LIKE ? OR e.rut LIKE ? OR e.email LIKE ?)';
            $s        = "%$search%";
            $params[] = $s; $params[] = $s; $params[] = $s;
        }
        $sql = "SELECT e.*, p.nombre as plan_nombre,
                       (SELECT COUNT(*) FROM sucursales WHERE empresa_id = e.id) as total_sucursales,
                       (SELECT COUNT(*) FROM usuarios WHERE empresa_id = e.id) as total_usuarios
                FROM empresas e
                LEFT JOIN planes p ON e.plan_id = p.id
                WHERE $where ORDER BY e.nombre ASC";
        return $this->db->paginate($sql, $params, $page);
    }

    public function getById(int $id): array|false
    {
        return $this->db->fetchOne(
            "SELECT e.*, p.nombre as plan_nombre, p.max_sucursales, p.max_usuarios,
                    p.max_productos, p.max_pacientes, p.tiene_laboratorio, p.tiene_agenda
             FROM empresas e
             LEFT JOIN planes p ON e.plan_id = p.id
             WHERE e.id = ?",
            [$id]
        );
    }

    public function getMetricas(): array
    {
        return $this->db->fetchOne(
            "SELECT
                COUNT(*) as total_empresas,
                SUM(estado = 'activa') as empresas_activas,
                SUM(estado = 'suspendida') as empresas_suspendidas,
                SUM(estado = 'prueba') as empresas_prueba
             FROM empresas"
        ) ?: [];
    }

    public function getSucursales(int $empresaId): array
    {
        return $this->db->fetchAll(
            "SELECT * FROM sucursales WHERE empresa_id = ? ORDER BY es_principal DESC, nombre",
            [$empresaId]
        );
    }

    // ── Crear empresa ─────────────────────────────────────────
    public function crear(array $data): int
    {
        return $this->db->insert('empresas', [
            'plan_id'        => $data['plan_id'],
            'nombre'         => trim($data['nombre']),
            'razon_social'   => trim($data['razon_social'] ?? ''),
            'rut'            => trim($data['rut'] ?? '') ?: null,
            'email'          => trim($data['email']),
            'telefono'       => trim($data['telefono'] ?? '') ?: null,
            'direccion'      => trim($data['direccion'] ?? '') ?: null,
            'ciudad'         => trim($data['ciudad'] ?? '') ?: null,
            'pais'           => $data['pais'] ?? 'Chile',
            'moneda'         => $data['moneda'] ?? 'CLP',
            'color_primario' => $data['color_primario'] ?? '#0d6efd',
            'estado'         => $data['estado'] ?? 'prueba',
        ]);
    }

    // ── Actualizar empresa ────────────────────────────────────
    public function actualizar(int $id, array $data): int
    {
        $campos = [
            'plan_id'        => $data['plan_id'],
            'nombre'         => trim($data['nombre']),
            'razon_social'   => trim($data['razon_social'] ?? ''),
            'rut'            => trim($data['rut'] ?? '') ?: null,
            'email'          => trim($data['email'] ?? ''),
            'telefono'       => trim($data['telefono'] ?? '') ?: null,
            'direccion'      => trim($data['direccion'] ?? '') ?: null,
            'ciudad'         => trim($data['ciudad'] ?? '') ?: null,
            'pais'           => $data['pais'] ?? 'Chile',
            'moneda'         => $data['moneda'] ?? 'CLP',
            'color_primario' => $data['color_primario'] ?? '#0d6efd',
            'estado'         => $data['estado'] ?? 'activa',
        ];
        if (array_key_exists('logo', $data)) {
            $campos['logo'] = $data['logo'];
        }
        return $this->db->update('empresas', $campos, ['id' => $id]);
    }

    // ── Eliminar / desactivar empresa ─────────────────────────
    public function eliminar(int $id): int
    {
        return $this->db->update('empresas', ['estado' => 'inactiva'], ['id' => $id]);
    }
}
