<?php
class Rol extends BaseModel
{
    protected string $table = 'roles';

    public function getAll(): array
    {
        if (Auth::isSuperAdmin()) {
            return $this->db->fetchAll(
                "SELECT r.*, COUNT(u.id) as total_usuarios
                 FROM roles r
                 LEFT JOIN usuarios u ON u.rol_id = r.id
                 WHERE r.slug != 'superadmin'
                 GROUP BY r.id ORDER BY r.nombre"
            );
        }

        $empresaId = $this->empresaScope();
        return $this->db->fetchAll(
            "SELECT r.*, COUNT(u.id) as total_usuarios
             FROM roles r
             LEFT JOIN usuarios u ON u.rol_id = r.id
             WHERE (r.empresa_id = ? OR r.empresa_id IS NULL) AND r.slug != 'superadmin'
             GROUP BY r.id ORDER BY r.nombre",
            [$empresaId]
        );
    }

    public function getById(int $id): array|false
    {
        return $this->db->fetchOne("SELECT * FROM roles WHERE id = ?", [$id]);
    }

    public function getPermisos(int $rolId): array
    {
        return $this->db->fetchAll(
            "SELECT p.*, COALESCE(rp.granted, 0) as granted
             FROM permisos p
             LEFT JOIN rol_permisos rp ON p.id = rp.permiso_id AND rp.rol_id = ?
             ORDER BY p.modulo, p.nombre",
            [$rolId]
        );
    }

    public function getPermisosAgrupados(int $rolId): array
    {
        $permisos = $this->getPermisos($rolId);
        $grouped  = [];
        foreach ($permisos as $p) {
            $grouped[$p['modulo']][] = $p;
        }
        return $grouped;
    }

    public function sincronizarPermisos(int $rolId, array $permisoIds): void
    {
        $db = $this->db;
        $db->beginTransaction();
        try {
            $db->query("DELETE FROM rol_permisos WHERE rol_id = ?", [$rolId]);
            foreach ($permisoIds as $pid) {
                $db->insert('rol_permisos', ['rol_id' => $rolId, 'permiso_id' => $pid, 'granted' => 1]);
            }
            $db->commit();
        } catch (Exception $e) {
            $db->rollBack();
            throw $e;
        }
    }

    public function getTodosPermisos(): array
    {
        $permisos = $this->db->fetchAll("SELECT * FROM permisos ORDER BY modulo, nombre");
        $grouped  = [];
        foreach ($permisos as $p) {
            $grouped[$p['modulo']][] = $p;
        }
        return $grouped;
    }
}
