<?php /* Vista: Apertura de Caja */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-unlock text-success me-2"></i>Apertura de Caja</h4>
    <a href="<?= BASE_URL ?>/caja" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-md-6 col-lg-5">
<div class="card border-0 shadow-sm">
    <div class="card-header bg-success text-white text-center py-3">
        <i class="bi bi-cash-register fs-2 d-block mb-1"></i>
        <h5 class="mb-0 fw-bold">Abrir Caja</h5>
        <small class="opacity-75"><?= date('d/m/Y') ?> — <?= formatDateTime(date('Y-m-d H:i:s'), 'H:i') ?></small>
    </div>
    <div class="card-body p-4">
        <form method="POST" action="<?= BASE_URL ?>/caja/apertura">
            <?= csrf_field() ?>

            <div class="mb-3">
                <label class="form-label fw-medium">Sucursal</label>
                <select name="sucursal_id" class="form-select" required>
                    <?php foreach ($sucursales as $s): ?>
                    <option value="<?= $s['id'] ?>" <?= Auth::sucursalId() == $s['id'] ? 'selected' : '' ?>>
                        <?= clean($s['nombre']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label fw-medium">Saldo Inicial (efectivo en caja) <span class="text-danger">*</span></label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text fw-bold"><?= Auth::moneda() ?></span>
                    <input type="number" name="saldo_inicial" class="form-control form-control-lg text-end"
                           value="0" min="0" step="0.01" required autofocus>
                </div>
                <div class="form-text">Ingresa el monto de efectivo con que inicia la caja.</div>
            </div>

            <div class="mb-4">
                <label class="form-label fw-medium">Observaciones</label>
                <textarea name="observaciones" class="form-control" rows="2"
                          placeholder="Notas de apertura (opcional)..."></textarea>
            </div>

            <button type="submit" class="btn btn-success w-100 btn-lg">
                <i class="bi bi-unlock me-2"></i>Abrir Caja
            </button>
        </form>
    </div>
</div>

<?php if (!empty($ultimaCaja)): ?>
<div class="card border-0 shadow-sm mt-3">
    <div class="card-body small">
        <h6 class="fw-semibold mb-2">Última Caja Cerrada</h6>
        <dl class="row mb-0">
            <dt class="col-6 text-muted">Fecha apertura</dt>
            <dd class="col-6"><?= formatDateTime($ultimaCaja['fecha_apertura']) ?></dd>
            <dt class="col-6 text-muted">Fecha cierre</dt>
            <dd class="col-6"><?= formatDateTime($ultimaCaja['fecha_cierre']) ?></dd>
            <dt class="col-6 text-muted">Saldo inicial</dt>
            <dd class="col-6"><?= formatMoney($ultimaCaja['monto_apertura'], Auth::moneda()) ?></dd>
            <dt class="col-6 text-muted">Saldo final</dt>
            <dd class="col-6"><?= formatMoney($ultimaCaja['monto_cierre_real'] ?? 0, Auth::moneda()) ?></dd>
        </dl>
    </div>
</div>
<?php endif; ?>

</div>
</div>
