<?php /* Vista: Cierre de Caja */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-lock text-danger me-2"></i>Cierre de Caja</h4>
    <a href="<?= BASE_URL ?>/caja" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row g-3">
    <!-- Resumen -->
    <div class="col-lg-7">
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Resumen de la Caja</h6></div>
            <div class="card-body">
                <dl class="row mb-0">
                    <dt class="col-6 text-muted">Apertura</dt>
                    <dd class="col-6"><?= formatDateTime($caja['fecha_apertura']) ?></dd>
                    <dt class="col-6 text-muted">Sucursal</dt>
                    <dd class="col-6"><?= clean($caja['sucursal_nombre']) ?></dd>
                    <dt class="col-6 text-muted">Saldo Inicial</dt>
                    <dd class="col-6 fw-medium"><?= formatMoney($caja['monto_apertura'], Auth::moneda()) ?></dd>
                </dl>
                <hr>
                <dl class="row mb-0">
                    <dt class="col-6 text-muted">Total Ventas</dt>
                    <dd class="col-6 text-success fw-medium"><?= formatMoney($resumen['total_ventas'] ?? 0, Auth::moneda()) ?></dd>
                    <dt class="col-6 text-muted">N° Ventas</dt>
                    <dd class="col-6"><?= $resumen['cantidad_ventas'] ?? 0 ?></dd>
                    <dt class="col-6 text-muted">Ingresos Extra</dt>
                    <dd class="col-6 text-success"><?= formatMoney($resumen['total_ingresos'] ?? 0, Auth::moneda()) ?></dd>
                    <dt class="col-6 text-muted">Egresos</dt>
                    <dd class="col-6 text-danger">-<?= formatMoney($resumen['total_egresos'] ?? 0, Auth::moneda()) ?></dd>
                </dl>
                <hr>
                <dl class="row mb-0">
                    <dt class="col-6 fw-bold">Saldo Esperado</dt>
                    <dd class="col-6 fw-bold text-primary fs-6"><?= formatMoney($saldoEsperado, Auth::moneda()) ?></dd>
                </dl>
            </div>
        </div>

        <!-- Desglose por método de pago -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Ventas por Método de Pago</h6></div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="table-light">
                        <tr><th>Método</th><th class="text-center">N° Ventas</th><th class="text-end">Total</th></tr>
                    </thead>
                    <tbody>
                    <?php foreach ($porMetodo as $m): ?>
                    <tr>
                        <td class="small"><i class="bi bi-<?= ($m['tipo'] ?? '') === 'efectivo' ? 'cash' : 'credit-card' ?> me-1"></i>
                            <?= clean($m['forma_pago'] ?? '-') ?>
                        </td>
                        <td class="text-center small">—</td>
                        <td class="text-end small fw-medium"><?= formatMoney($m['ingresos'] ?? 0, Auth::moneda()) ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($porMetodo)): ?>
                    <tr><td colspan="3" class="text-center text-muted py-2">Sin ventas registradas.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Formulario de cierre -->
    <div class="col-lg-5">
        <div class="card border-0 shadow-sm border-danger">
            <div class="card-header bg-danger text-white text-center py-3">
                <i class="bi bi-lock fs-2 d-block mb-1"></i>
                <h5 class="mb-0 fw-bold">Cerrar Caja</h5>
            </div>
            <div class="card-body p-4">
                <form method="POST" action="<?= BASE_URL ?>/caja/cierre"
                      onsubmit="return confirm('¿Confirmas el cierre de caja? Esta acción no se puede deshacer.')">
                    <?= csrf_field() ?>

                    <div class="mb-3">
                        <label class="form-label fw-medium">Saldo Real en Caja <span class="text-danger">*</span></label>
                        <div class="input-group input-group-lg">
                            <span class="input-group-text fw-bold"><?= Auth::moneda() ?></span>
                            <input type="number" name="saldo_final" id="saldoFinal" class="form-control form-control-lg text-end"
                                   value="<?= $saldoEsperado ?>" min="0" step="0.01" required
                                   oninput="calcularDiferencia()">
                        </div>
                        <div class="form-text">Cuenta el efectivo físico en caja.</div>
                    </div>

                    <div class="alert alert-light border mb-3" id="alertaDiferencia">
                        <div class="d-flex justify-content-between small">
                            <span>Saldo esperado:</span>
                            <strong><?= formatMoney($saldoEsperado, Auth::moneda()) ?></strong>
                        </div>
                        <div class="d-flex justify-content-between small">
                            <span>Saldo real:</span>
                            <strong id="txtSaldoReal"><?= formatMoney($saldoEsperado, Auth::moneda()) ?></strong>
                        </div>
                        <hr class="my-1">
                        <div class="d-flex justify-content-between fw-bold">
                            <span>Diferencia:</span>
                            <span id="txtDiferencia" class="text-success">$0</span>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label fw-medium">Observaciones de Cierre</label>
                        <textarea name="observaciones" class="form-control" rows="3"
                                  placeholder="Notas, diferencias, incidencias..."></textarea>
                    </div>

                    <button type="submit" class="btn btn-danger w-100 btn-lg">
                        <i class="bi bi-lock me-2"></i>Confirmar Cierre
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
const saldoEsperado = <?= $saldoEsperado ?>;
const moneda = '<?= Auth::moneda() ?>';

function fmt(n) {
    return new Intl.NumberFormat('es-CL', { style: 'currency', currency: moneda }).format(n);
}

function calcularDiferencia() {
    const real = parseFloat(document.getElementById('saldoFinal').value) || 0;
    const diff = real - saldoEsperado;
    const el   = document.getElementById('txtDiferencia');
    document.getElementById('txtSaldoReal').textContent = fmt(real);
    el.textContent  = fmt(diff);
    el.className    = diff >= 0 ? 'text-success' : 'text-danger';
}
</script>
