<?php /* Vista: Nueva Categoría */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-tags text-primary me-2"></i>Nueva Categoría</h4>
    <a href="<?= BASE_URL ?>/categorias" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-6">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/categorias">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-12">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control"
                   value="<?= clean(post('nombre')) ?>" required autofocus
                   placeholder="Ej: Armazones, Lentes de Contacto...">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="3"
                      placeholder="Descripción opcional..."><?= clean(post('descripcion')) ?></textarea>
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activa" <?= post('estado', 'activa') === 'activa' ? 'selected' : '' ?>>Activa</option>
                <option value="inactiva" <?= post('estado') === 'inactiva' ? 'selected' : '' ?>>Inactiva</option>
            </select>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/categorias" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Categoría
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
