<?php /* Vista: Formas de Pago */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-credit-card text-primary me-2"></i>Formas de Pago</h4>
    <?php if (can('formas_pago.crear')): ?>
    <a href="<?= BASE_URL ?>/formas-pago/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Forma de Pago
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/formas-pago" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:280px"
                   placeholder="Buscar forma de pago..." value="<?= clean($busqueda ?? '') ?>">
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <?php if (!empty($busqueda)): ?>
            <a href="<?= BASE_URL ?>/formas-pago" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
            <?php endif; ?>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Nombre</th>
                        <th>Tipo</th>
                        <th>Requiere Referencia</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($formas_pago as $fp): ?>
                <tr>
                    <td class="text-muted small"><?= $fp['id'] ?></td>
                    <td class="fw-semibold"><?= clean($fp['nombre']) ?></td>
                    <td>
                        <?php
                        $tipoIcons = [
                            'efectivo'       => ['icon' => 'bi-cash',           'class' => 'bg-success',          'label' => 'Efectivo'],
                            'tarjeta_debito' => ['icon' => 'bi-credit-card',    'class' => 'bg-primary',          'label' => 'Débito'],
                            'tarjeta_credito'=> ['icon' => 'bi-credit-card-2-front', 'class' => 'bg-info text-dark', 'label' => 'Crédito'],
                            'transferencia'  => ['icon' => 'bi-bank',           'class' => 'bg-warning text-dark','label' => 'Transferencia'],
                            'cheque'         => ['icon' => 'bi-file-text',      'class' => 'bg-secondary',        'label' => 'Cheque'],
                            'otro'           => ['icon' => 'bi-three-dots',     'class' => 'bg-secondary',        'label' => 'Otro'],
                        ];
                        $t = $tipoIcons[$fp['tipo']] ?? ['icon' => 'bi-question', 'class' => 'bg-secondary', 'label' => $fp['tipo']];
                        ?>
                        <span class="badge <?= $t['class'] ?>">
                            <i class="<?= $t['icon'] ?> me-1"></i><?= $t['label'] ?>
                        </span>
                    </td>
                    <td>
                        <?php if (!empty($fp['requiere_referencia'])): ?>
                        <span class="badge bg-warning text-dark"><i class="bi bi-check-lg me-1"></i>Sí</span>
                        <?php else: ?>
                        <span class="text-muted small">No</span>
                        <?php endif; ?>
                    </td>
                    <td><?= statusBadge($fp['estado']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <?php if (can('formas_pago.editar')): ?>
                            <a href="<?= BASE_URL ?>/formas-pago/<?= $fp['id'] ?>/edit"
                               class="btn btn-outline-primary" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('formas_pago.eliminar')): ?>
                            <form method="POST" action="<?= BASE_URL ?>/formas-pago/<?= $fp['id'] ?>/delete"
                                  data-confirm="¿Desactivar esta forma de pago?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger" title="Desactivar">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($formas_pago)): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted py-4">
                        <i class="bi bi-credit-card fs-3 d-block mb-2 opacity-25"></i>
                        No hay formas de pago registradas.
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if (!empty($pagination) && $pagination['last_page'] > 1): ?>
    <div class="card-footer bg-white d-flex justify-content-between align-items-center">
        <small class="text-muted">
            Mostrando <?= $pagination['from'] ?>–<?= $pagination['to'] ?> de <?= $pagination['total'] ?>
        </small>
        <?= paginationLinks($pagination, BASE_URL . '/formas-pago') ?>
    </div>
    <?php endif; ?>
</div>
