<?php /* Vista: Nueva Orden de Laboratorio */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-eyeglasses text-primary me-2"></i>Nueva Orden de Laboratorio</h4>
    <a href="<?= BASE_URL ?>/laboratorio" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-8">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/laboratorio">
    <?= csrf_field() ?>
    <div class="row g-3">

        <!-- Paciente -->
        <div class="col-12">
            <label class="form-label fw-medium">Paciente</label>
            <input type="text" name="nombre_paciente" class="form-control"
                   value="<?= clean(post('nombre_paciente')) ?>"
                   placeholder="Nombre del paciente (opcional si no está registrado)...">
            <div class="form-text">Si el paciente está registrado, puedes ingresar su nombre aquí.</div>
        </div>

        <!-- Proveedor laboratorio -->
        <div class="col-md-6">
            <label class="form-label fw-medium">Laboratorio / Proveedor</label>
            <select name="proveedor_id" class="form-select">
                <option value="">Sin proveedor asignado</option>
                <?php foreach ($proveedores as $prov): ?>
                <option value="<?= $prov['id'] ?>" <?= post('proveedor_id') == $prov['id'] ? 'selected' : '' ?>>
                    <?= clean($prov['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Fecha recepción -->
        <div class="col-md-3">
            <label class="form-label fw-medium">Fecha Recepción <span class="text-danger">*</span></label>
            <input type="date" name="fecha_recepcion" class="form-control"
                   value="<?= clean(post('fecha_recepcion', date('Y-m-d'))) ?>" required>
        </div>

        <!-- Fecha entrega estimada -->
        <div class="col-md-3">
            <label class="form-label fw-medium">Entrega Estimada</label>
            <input type="date" name="fecha_entrega_estimada" class="form-control"
                   value="<?= clean(post('fecha_entrega_estimada')) ?>">
        </div>

        <!-- Descripción del trabajo -->
        <div class="col-12">
            <label class="form-label fw-medium">Descripción del Trabajo <span class="text-danger">*</span></label>
            <textarea name="descripcion" class="form-control" rows="3" required
                      placeholder="Detalle del trabajo a realizar: tipo de lente, graduación, tratamientos..."><?= clean(post('descripcion')) ?></textarea>
        </div>

        <!-- Datos ópticos -->
        <div class="col-12">
            <div class="card bg-light border-0">
                <div class="card-body">
                    <h6 class="fw-bold mb-3"><i class="bi bi-eye me-2"></i>Datos de Graduación (Opcional)</h6>
                    <div class="row g-2">
                        <div class="col-12">
                            <p class="text-muted small mb-2">Ojo Derecho (OD)</p>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">Esfera OD</label>
                            <input type="number" name="od_esfera" class="form-control form-control-sm"
                                   step="0.25" value="<?= clean(post('od_esfera')) ?>" placeholder="0.00">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">Cilindro OD</label>
                            <input type="number" name="od_cilindro" class="form-control form-control-sm"
                                   step="0.25" value="<?= clean(post('od_cilindro')) ?>" placeholder="0.00">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">Eje OD</label>
                            <input type="number" name="od_eje" class="form-control form-control-sm"
                                   min="0" max="180" value="<?= clean(post('od_eje')) ?>" placeholder="0">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">ADD OD</label>
                            <input type="number" name="od_adicion" class="form-control form-control-sm"
                                   step="0.25" value="<?= clean(post('od_adicion')) ?>" placeholder="0.00">
                        </div>
                        <div class="col-12 mt-2">
                            <p class="text-muted small mb-2">Ojo Izquierdo (OI)</p>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">Esfera OI</label>
                            <input type="number" name="oi_esfera" class="form-control form-control-sm"
                                   step="0.25" value="<?= clean(post('oi_esfera')) ?>" placeholder="0.00">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">Cilindro OI</label>
                            <input type="number" name="oi_cilindro" class="form-control form-control-sm"
                                   step="0.25" value="<?= clean(post('oi_cilindro')) ?>" placeholder="0.00">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">Eje OI</label>
                            <input type="number" name="oi_eje" class="form-control form-control-sm"
                                   min="0" max="180" value="<?= clean(post('oi_eje')) ?>" placeholder="0">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small">ADD OI</label>
                            <input type="number" name="oi_adicion" class="form-control form-control-sm"
                                   step="0.25" value="<?= clean(post('oi_adicion')) ?>" placeholder="0.00">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Costo y notas -->
        <div class="col-md-4">
            <label class="form-label fw-medium">Costo del Laboratorio</label>
            <div class="input-group">
                <span class="input-group-text">$</span>
                <input type="number" name="costo" class="form-control"
                       step="1" min="0" value="<?= clean(post('costo', '0')) ?>" placeholder="0">
            </div>
        </div>
        <div class="col-md-8">
            <label class="form-label fw-medium">Notas Internas</label>
            <input type="text" name="notas" class="form-control"
                   value="<?= clean(post('notas')) ?>" placeholder="Observaciones adicionales...">
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/laboratorio" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Orden
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
