<?php /* Vista: Detalle Orden de Laboratorio */
$estadoClases = [
    'recibido'   => 'bg-secondary',
    'en_proceso' => 'bg-warning text-dark',
    'listo'      => 'bg-success',
    'entregado'  => 'bg-primary',
    'cancelado'  => 'bg-danger',
];
$estadoLabels = [
    'recibido'   => 'Recibido',
    'en_proceso' => 'En Proceso',
    'listo'      => 'Listo',
    'entregado'  => 'Entregado',
    'cancelado'  => 'Cancelado',
];
$cls = $estadoClases[$orden['estado']] ?? 'bg-secondary';
$lbl = $estadoLabels[$orden['estado']] ?? $orden['estado'];
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0 fw-bold">
            <i class="bi bi-eyeglasses text-primary me-2"></i>
            Orden <?= clean($orden['correlativo']) ?>
        </h4>
        <span class="badge <?= $cls ?> mt-1"><?= $lbl ?></span>
    </div>
    <div class="d-flex gap-2">
        <?php if (can('laboratorio.editar')): ?>
        <a href="<?= BASE_URL ?>/laboratorio/<?= $orden['id'] ?>/edit" class="btn btn-outline-primary btn-sm">
            <i class="bi bi-pencil me-1"></i>Editar
        </a>
        <?php endif; ?>
        <a href="<?= BASE_URL ?>/laboratorio" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<div class="row g-4">
    <!-- Información principal -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-white fw-semibold border-bottom">
                <i class="bi bi-info-circle me-2 text-primary"></i>Información de la Orden
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="text-muted small">Paciente</label>
                        <p class="fw-semibold mb-0"><?= clean($orden['paciente_nombre'] ?? 'No especificado') ?></p>
                    </div>
                    <div class="col-md-6">
                        <label class="text-muted small">Laboratorio / Proveedor</label>
                        <p class="fw-semibold mb-0"><?= clean($orden['proveedor_nombre'] ?? 'No asignado') ?></p>
                    </div>
                    <div class="col-md-4">
                        <label class="text-muted small">Fecha Recepción</label>
                        <p class="fw-semibold mb-0">
                            <?= $orden['fecha_recepcion'] ? date('d/m/Y', strtotime($orden['fecha_recepcion'])) : '-' ?>
                        </p>
                    </div>
                    <div class="col-md-4">
                        <label class="text-muted small">Entrega Estimada</label>
                        <p class="fw-semibold mb-0">
                            <?= !empty($orden['fecha_entrega_estimada']) ? date('d/m/Y', strtotime($orden['fecha_entrega_estimada'])) : '-' ?>
                        </p>
                    </div>
                    <div class="col-md-4">
                        <label class="text-muted small">Fecha Entrega Real</label>
                        <p class="fw-semibold mb-0">
                            <?= !empty($orden['fecha_entrega_real']) ? date('d/m/Y', strtotime($orden['fecha_entrega_real'])) : '-' ?>
                        </p>
                    </div>
                    <div class="col-12">
                        <label class="text-muted small">Descripción del Trabajo</label>
                        <p class="mb-0"><?= nl2br(clean($orden['descripcion'])) ?></p>
                    </div>
                    <?php if (!empty($orden['notas'])): ?>
                    <div class="col-12">
                        <label class="text-muted small">Notas Internas</label>
                        <p class="mb-0 text-muted"><?= nl2br(clean($orden['notas'])) ?></p>
                    </div>
                    <?php endif; ?>
                    <?php if (!empty($orden['costo'])): ?>
                    <div class="col-md-4">
                        <label class="text-muted small">Costo Laboratorio</label>
                        <p class="fw-bold text-primary mb-0"><?= formatMoney($orden['costo']) ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Datos ópticos -->
        <?php
        $tieneOpticos = !empty($orden['od_esfera']) || !empty($orden['oi_esfera'])
                     || !empty($orden['od_cilindro']) || !empty($orden['oi_cilindro']);
        ?>
        <?php if ($tieneOpticos): ?>
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white fw-semibold border-bottom">
                <i class="bi bi-eye me-2 text-primary"></i>Datos de Graduación
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-center align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Ojo</th>
                                <th>Esfera</th>
                                <th>Cilindro</th>
                                <th>Eje</th>
                                <th>Adición</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="fw-semibold">OD</td>
                                <td><?= formatReceta($orden['od_esfera'] ?? null) ?></td>
                                <td><?= formatReceta($orden['od_cilindro'] ?? null) ?></td>
                                <td><?= $orden['od_eje'] ?? '-' ?>°</td>
                                <td><?= formatReceta($orden['od_adicion'] ?? null) ?></td>
                            </tr>
                            <tr>
                                <td class="fw-semibold">OI</td>
                                <td><?= formatReceta($orden['oi_esfera'] ?? null) ?></td>
                                <td><?= formatReceta($orden['oi_cilindro'] ?? null) ?></td>
                                <td><?= $orden['oi_eje'] ?? '-' ?>°</td>
                                <td><?= formatReceta($orden['oi_adicion'] ?? null) ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Panel lateral: cambiar estado -->
    <?php if (can('laboratorio.editar')): ?>
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white fw-semibold border-bottom">
                <i class="bi bi-arrow-repeat me-2 text-primary"></i>Cambiar Estado
            </div>
            <div class="card-body">
                <form method="POST" action="<?= BASE_URL ?>/laboratorio/<?= $orden['id'] ?>/estado">
                    <?= csrf_field() ?>
                    <div class="mb-3">
                        <label class="form-label fw-medium">Nuevo Estado</label>
                        <select name="estado" class="form-select">
                            <option value="recibido"   <?= $orden['estado'] === 'recibido'   ? 'selected' : '' ?>>Recibido</option>
                            <option value="en_proceso" <?= $orden['estado'] === 'en_proceso' ? 'selected' : '' ?>>En Proceso</option>
                            <option value="listo"      <?= $orden['estado'] === 'listo'      ? 'selected' : '' ?>>Listo</option>
                            <option value="entregado"  <?= $orden['estado'] === 'entregado'  ? 'selected' : '' ?>>Entregado</option>
                            <option value="cancelado"  <?= $orden['estado'] === 'cancelado'  ? 'selected' : '' ?>>Cancelado</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-check-lg me-1"></i>Actualizar Estado
                    </button>
                </form>
            </div>
        </div>

        <!-- Metadatos -->
        <div class="card border-0 shadow-sm mt-3">
            <div class="card-body">
                <p class="text-muted small mb-1">
                    <i class="bi bi-calendar me-1"></i>
                    Creado: <?= $orden['created_at'] ? date('d/m/Y H:i', strtotime($orden['created_at'])) : '-' ?>
                </p>
                <p class="text-muted small mb-0">
                    <i class="bi bi-pencil me-1"></i>
                    Actualizado: <?= $orden['updated_at'] ? date('d/m/Y H:i', strtotime($orden['updated_at'])) : '-' ?>
                </p>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
