<?php
/**
 * OptiCore SaaS - Layout Principal
 * Bootstrap 5.3 + Bootstrap Icons
 */
$user       = Auth::user();
$flashMsgs  = getFlash();
$moneda     = Auth::moneda();
?>
<!DOCTYPE html>
<html lang="es" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?= csrf_token() ?>">
    <title><?= clean($title ?? 'Dashboard') ?> | <?= APP_NAME ?></title>

    <!-- Bootstrap 5.3 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- App CSS -->
    <link rel="stylesheet" href="<?= asset('css/app.css') ?>">
</head>
<body>

<!-- ── Navbar ──────────────────────────────────────────────── -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top shadow-sm">
    <div class="container-fluid">
        <!-- Brand -->
        <a class="navbar-brand fw-bold d-flex align-items-center gap-2" href="<?= BASE_URL ?>/dashboard">
            <i class="bi bi-eye-fill fs-5"></i>
            <span><?= APP_NAME ?></span>
        </a>

        <!-- Toggle mobile -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarMain">
            <!-- Nav izquierda -->
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">

                <li class="nav-item">
                    <a class="nav-link <?= isActiveUrl('/dashboard') ?>" href="<?= BASE_URL ?>/dashboard">
                        <i class="bi bi-speedometer2"></i> Dashboard
                    </a>
                </li>

                <?php if (can('pacientes.ver')): ?>
                <li class="nav-item">
                    <a class="nav-link <?= isActiveUrl('/pacientes') ?>" href="<?= BASE_URL ?>/pacientes">
                        <i class="bi bi-people"></i> Pacientes
                    </a>
                </li>
                <?php endif; ?>

                <?php if (can('recetas.ver')): ?>
                <li class="nav-item">
                    <a class="nav-link <?= isActiveUrl('/recetas') ?>" href="<?= BASE_URL ?>/recetas">
                        <i class="bi bi-file-medical"></i> Recetas
                    </a>
                </li>
                <?php endif; ?>

                <?php if (can('ventas.ver') || can('productos.ver') || can('stock.ver')): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= isActiveUrl('/ventas') ?: isActiveUrl('/productos') ?: isActiveUrl('/stock') ?>"
                       href="#" data-bs-toggle="dropdown">
                        <i class="bi bi-cart3"></i> Comercial
                    </a>
                    <ul class="dropdown-menu">
                        <?php if (can('ventas.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/ventas">
                            <i class="bi bi-receipt me-2"></i>Ventas
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('productos.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/productos">
                            <i class="bi bi-box-seam me-2"></i>Productos
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('stock.ver')): ?>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/stock">
                            <i class="bi bi-archive me-2"></i>Stock
                        </a></li>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/stock/movimientos">
                            <i class="bi bi-arrow-left-right me-2"></i>Movimientos
                        </a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <?php if (can('agenda.ver')): ?>
                <li class="nav-item">
                    <a class="nav-link <?= isActiveUrl('/agenda') ?>" href="<?= BASE_URL ?>/agenda">
                        <i class="bi bi-calendar3"></i> Agenda
                    </a>
                </li>
                <?php endif; ?>

                <?php if (can('laboratorio.ver')): ?>
                <li class="nav-item">
                    <a class="nav-link <?= isActiveUrl('/laboratorio') ?>" href="<?= BASE_URL ?>/laboratorio">
                        <i class="bi bi-eyeglasses"></i> Laboratorio
                    </a>
                </li>
                <?php endif; ?>

                <?php if (can('caja.ver')): ?>
                <li class="nav-item">
                    <a class="nav-link <?= isActiveUrl('/caja') ?>" href="<?= BASE_URL ?>/caja">
                        <i class="bi bi-cash-register"></i> Caja
                    </a>
                </li>
                <?php endif; ?>

                <?php if (can('reportes.ver')): ?>
                <li class="nav-item">
                    <a class="nav-link <?= isActiveUrl('/reportes') ?>" href="<?= BASE_URL ?>/reportes">
                        <i class="bi bi-bar-chart-line"></i> Reportes
                    </a>
                </li>
                <?php endif; ?>

                <!-- SuperAdmin -->
                <?php if (isSuperAdmin()): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-warning" href="#" data-bs-toggle="dropdown">
                        <i class="bi bi-shield-lock"></i> Admin
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/empresas">
                            <i class="bi bi-building me-2"></i>Empresas
                        </a></li>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/planes">
                            <i class="bi bi-layers me-2"></i>Planes
                        </a></li>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/licencias">
                            <i class="bi bi-key me-2"></i>Licencias
                        </a></li>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Config empresa -->
                <?php if (canAny(['usuarios.ver','roles.ver','sucursales.ver','categorias.ver','marcas.ver','proveedores.ver','formas_pago.ver','audit_logs.ver'])): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= isActiveUrl('/usuarios') ?: isActiveUrl('/roles') ?: isActiveUrl('/sucursales') ?: isActiveUrl('/categorias') ?: isActiveUrl('/marcas') ?: isActiveUrl('/proveedores') ?: isActiveUrl('/formas-pago') ?>"
                       href="#" data-bs-toggle="dropdown">
                        <i class="bi bi-gear"></i> Config
                    </a>
                    <ul class="dropdown-menu">
                        <?php if (can('usuarios.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/usuarios">
                            <i class="bi bi-person-gear me-2"></i>Usuarios
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('roles.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/roles">
                            <i class="bi bi-shield-check me-2"></i>Roles
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('sucursales.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/sucursales">
                            <i class="bi bi-shop me-2"></i>Sucursales
                        </a></li>
                        <?php endif; ?>
                        <?php if (canAny(['categorias.ver','marcas.ver','proveedores.ver','formas_pago.ver'])): ?>
                        <li><hr class="dropdown-divider"></li>
                        <li><h6 class="dropdown-header small">Catálogos</h6></li>
                        <?php endif; ?>
                        <?php if (can('categorias.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/categorias">
                            <i class="bi bi-tags me-2"></i>Categorías
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('marcas.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/marcas">
                            <i class="bi bi-bookmark-star me-2"></i>Marcas
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('proveedores.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/proveedores">
                            <i class="bi bi-truck me-2"></i>Proveedores
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('formas_pago.ver')): ?>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/formas-pago">
                            <i class="bi bi-credit-card me-2"></i>Formas de Pago
                        </a></li>
                        <?php endif; ?>
                        <?php if (can('audit_logs.ver')): ?>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/audit-logs">
                            <i class="bi bi-journal-text me-2"></i>Audit Logs
                        </a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
            </ul>

            <!-- Nav derecha -->
            <ul class="navbar-nav ms-auto align-items-center gap-1">
                <!-- Empresa/Sucursal info -->
                <?php if (!isSuperAdmin() && $user): ?>
                <li class="nav-item d-none d-lg-block">
                    <span class="navbar-text text-white-50 small">
                        <i class="bi bi-shop"></i>
                        <?= clean($user['sucursal_nombre'] ?? $user['empresa_nombre'] ?? '') ?>
                    </span>
                </li>
                <?php endif; ?>

                <!-- Usuario -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle d-flex align-items-center gap-2" href="#" data-bs-toggle="dropdown">
                        <?php if (!empty($user['avatar'])): ?>
                            <img src="<?= BASE_URL . '/' . $user['avatar'] ?>" class="rounded-circle" width="28" height="28" alt="">
                        <?php else: ?>
                            <div class="rounded-circle bg-white bg-opacity-25 d-flex align-items-center justify-content-center"
                                 style="width:28px;height:28px;font-size:13px;font-weight:600;color:#fff">
                                <?= strtoupper(substr($user['nombre'] ?? 'U', 0, 1)) ?>
                            </div>
                        <?php endif; ?>
                        <span class="d-none d-lg-inline"><?= clean($user['nombre'] ?? '') ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><h6 class="dropdown-header">
                            <?= clean(($user['nombre'] ?? '') . ' ' . ($user['apellido'] ?? '')) ?>
                            <br><small class="text-muted"><?= clean($user['rol_nombre'] ?? '') ?></small>
                        </h6></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="<?= BASE_URL ?>/perfil">
                                <i class="bi bi-person-circle me-2"></i>Mi Perfil
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item text-danger" href="<?= BASE_URL ?>/logout">
                                <i class="bi bi-box-arrow-right me-2"></i>Cerrar Sesión
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
<br><br>

<!-- ── Contenido principal ─────────────────────────────────── -->
<main class="main-content">
    <div class="container-fluid py-4">

        <!-- Flash messages -->
        <?php foreach ($flashMsgs as $flash): ?>
        <div class="alert alert-<?= $flash['type'] === 'error' ? 'danger' : $flash['type'] ?> alert-dismissible fade show" role="alert">
            <i class="bi bi-<?= match($flash['type']) {
                'success' => 'check-circle',
                'error'   => 'exclamation-triangle',
                'warning' => 'exclamation-circle',
                default   => 'info-circle'
            } ?> me-2"></i>
            <?= $flash['message'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endforeach; ?>

        <!-- Vista -->
        <?= $content ?>

    </div>
</main>

<!-- ── Footer ─────────────────────────────────────────────── -->
<footer class="footer text-center text-muted small py-2 border-top">
    <?= APP_NAME ?> v<?= APP_VERSION ?> &copy; <?= date('Y') ?>
</footer>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- App JS -->
<script src="<?= asset('js/app.js') ?>"></script>
</body>
</html>
