<?php
/**
 * OptiCore SaaS - Layout de Impresión
 */
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= clean($title ?? 'Imprimir') ?> | <?= APP_NAME ?></title>

    <!-- Bootstrap 5.3 (solo para estructura) -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            font-size: 12px;
            color: #000;
            background: #fff;
        }
        .print-header {
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        .print-footer {
            border-top: 1px solid #ccc;
            padding-top: 8px;
            margin-top: 15px;
            font-size: 10px;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table th, table td {
            border: 1px solid #ddd;
            padding: 5px 8px;
            font-size: 11px;
        }
        table th {
            background: #f5f5f5;
            font-weight: 600;
        }
        .no-print {
            display: block;
        }
        @media print {
            .no-print { display: none !important; }
            body { font-size: 11px; }
            @page { margin: 1cm; }
        }
    </style>
</head>
<body>

<!-- Barra de acciones (no se imprime) -->
<div class="no-print bg-light border-bottom py-2 px-3 d-flex gap-2 align-items-center">
    <button onclick="window.print()" class="btn btn-primary btn-sm">
        <i class="bi bi-printer me-1"></i> Imprimir
    </button>
    <button onclick="window.close()" class="btn btn-secondary btn-sm">
        <i class="bi bi-x-lg me-1"></i> Cerrar
    </button>
    <a href="javascript:history.back()" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i> Volver
    </a>
</div>

<!-- Contenido imprimible -->
<div class="container-fluid p-3">
    <?= $content ?>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Auto-imprimir si viene con ?autoprint=1
    const params = new URLSearchParams(window.location.search);
    if (params.get('autoprint') === '1') {
        window.addEventListener('load', () => window.print());
    }
</script>
</body>
</html>
