<?php /* Vista: Nuevo Proveedor */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-truck text-primary me-2"></i>Nuevo Proveedor</h4>
    <a href="<?= BASE_URL ?>/proveedores" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-7">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/proveedores">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre / Razón Social <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control"
                   value="<?= clean(post('nombre')) ?>" required autofocus
                   placeholder="Nombre del proveedor...">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Tipo <span class="text-danger">*</span></label>
            <select name="tipo" class="form-select" required>
                <option value="">Seleccionar...</option>
                <option value="productos"   <?= post('tipo') === 'productos'   ? 'selected' : '' ?>>Productos</option>
                <option value="laboratorio" <?= post('tipo') === 'laboratorio' ? 'selected' : '' ?>>Laboratorio</option>
                <option value="servicios"   <?= post('tipo') === 'servicios'   ? 'selected' : '' ?>>Servicios</option>
                <option value="otro"        <?= post('tipo') === 'otro'        ? 'selected' : '' ?>>Otro</option>
            </select>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">RUT / NIF</label>
            <input type="text" name="rut" class="form-control"
                   value="<?= clean(post('rut')) ?>" placeholder="Ej: 76.123.456-7">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Persona de Contacto</label>
            <input type="text" name="contacto" class="form-control"
                   value="<?= clean(post('contacto')) ?>" placeholder="Nombre del contacto...">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Teléfono</label>
            <input type="text" name="telefono" class="form-control"
                   value="<?= clean(post('telefono')) ?>" placeholder="+56 9 1234 5678">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Email</label>
            <input type="email" name="email" class="form-control"
                   value="<?= clean(post('email')) ?>" placeholder="proveedor@ejemplo.com">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Dirección</label>
            <input type="text" name="direccion" class="form-control"
                   value="<?= clean(post('direccion')) ?>" placeholder="Dirección del proveedor...">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Notas</label>
            <textarea name="notas" class="form-control" rows="3"
                      placeholder="Observaciones adicionales..."><?= clean(post('notas')) ?></textarea>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activo"   <?= post('estado', 'activo') === 'activo'   ? 'selected' : '' ?>>Activo</option>
                <option value="inactivo" <?= post('estado') === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
            </select>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/proveedores" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Proveedor
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
