<?php /* Vista: Proveedores */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-truck text-primary me-2"></i>Proveedores</h4>
    <?php if (can('proveedores.crear')): ?>
    <a href="<?= BASE_URL ?>/proveedores/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nuevo Proveedor
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/proveedores" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:260px"
                   placeholder="Buscar proveedor..." value="<?= clean($busqueda ?? '') ?>">
            <select name="tipo" class="form-select" style="max-width:180px">
                <option value="">Todos los tipos</option>
                <option value="productos"    <?= ($tipo ?? '') === 'productos'    ? 'selected' : '' ?>>Productos</option>
                <option value="laboratorio"  <?= ($tipo ?? '') === 'laboratorio'  ? 'selected' : '' ?>>Laboratorio</option>
                <option value="servicios"    <?= ($tipo ?? '') === 'servicios'    ? 'selected' : '' ?>>Servicios</option>
                <option value="otro"         <?= ($tipo ?? '') === 'otro'         ? 'selected' : '' ?>>Otro</option>
            </select>
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <?php if (!empty($busqueda) || !empty($tipo)): ?>
            <a href="<?= BASE_URL ?>/proveedores" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
            <?php endif; ?>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Nombre</th>
                        <th>Tipo</th>
                        <th>Contacto</th>
                        <th>Teléfono</th>
                        <th>Email</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($proveedores as $prov): ?>
                <tr>
                    <td class="text-muted small"><?= $prov['id'] ?></td>
                    <td class="fw-semibold"><?= clean($prov['nombre']) ?></td>
                    <td>
                        <?php
                        $tipoLabels = [
                            'productos'   => ['label' => 'Productos',   'class' => 'bg-primary'],
                            'laboratorio' => ['label' => 'Laboratorio', 'class' => 'bg-info text-dark'],
                            'servicios'   => ['label' => 'Servicios',   'class' => 'bg-warning text-dark'],
                            'otro'        => ['label' => 'Otro',        'class' => 'bg-secondary'],
                        ];
                        $t = $tipoLabels[$prov['tipo']] ?? ['label' => $prov['tipo'], 'class' => 'bg-secondary'];
                        ?>
                        <span class="badge <?= $t['class'] ?>"><?= $t['label'] ?></span>
                    </td>
                    <td class="text-muted small"><?= clean($prov['contacto'] ?? '-') ?></td>
                    <td class="text-muted small"><?= clean($prov['telefono'] ?? '-') ?></td>
                    <td class="text-muted small">
                        <?php if (!empty($prov['email'])): ?>
                        <a href="mailto:<?= clean($prov['email']) ?>"><?= clean($prov['email']) ?></a>
                        <?php else: ?>-<?php endif; ?>
                    </td>
                    <td><?= statusBadge($prov['estado']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <?php if (can('proveedores.editar')): ?>
                            <a href="<?= BASE_URL ?>/proveedores/<?= $prov['id'] ?>/edit"
                               class="btn btn-outline-primary" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('proveedores.eliminar')): ?>
                            <form method="POST" action="<?= BASE_URL ?>/proveedores/<?= $prov['id'] ?>/delete"
                                  data-confirm="¿Desactivar este proveedor?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger" title="Desactivar">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($proveedores)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted py-4">
                        <i class="bi bi-truck fs-3 d-block mb-2 opacity-25"></i>
                        No hay proveedores registrados.
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if (!empty($pagination) && $pagination['last_page'] > 1): ?>
    <div class="card-footer bg-white d-flex justify-content-between align-items-center">
        <small class="text-muted">
            Mostrando <?= $pagination['from'] ?>–<?= $pagination['to'] ?> de <?= $pagination['total'] ?>
        </small>
        <?= paginationLinks($pagination, BASE_URL . '/proveedores') ?>
    </div>
    <?php endif; ?>
</div>
