<?php /* Vista: Recetas */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-eyeglasses text-primary me-2"></i>Recetas Ópticas</h4>
    <?php if (can('recetas.crear')): ?>
    <a href="<?= BASE_URL ?>/recetas/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Receta
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/recetas" class="d-flex gap-2 flex-wrap">
            <input type="text" name="q" class="form-control" style="max-width:280px"
                   placeholder="Buscar paciente..." value="<?= clean(get('q')) ?>">
            <input type="date" name="desde" class="form-control" style="max-width:160px" value="<?= clean(get('desde')) ?>">
            <input type="date" name="hasta" class="form-control" style="max-width:160px" value="<?= clean(get('hasta')) ?>">
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <?php if (get('q') || get('desde') || get('hasta')): ?>
            <a href="<?= BASE_URL ?>/recetas" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
            <?php endif; ?>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Paciente</th>
                        <th>OD Esfera</th>
                        <th>OI Esfera</th>
                        <th>Tipo</th>
                        <th>Optometrista</th>
                        <th>Fecha</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($recetas as $r): ?>
                <tr>
                    <td class="text-muted small"><?= $r['id'] ?></td>
                    <td>
                        <a href="<?= BASE_URL ?>/pacientes/<?= $r['paciente_id'] ?>" class="text-decoration-none fw-semibold small">
                            <?= clean($r['paciente_nombre']) ?>
                        </a>
                    </td>
                    <td class="small font-monospace"><?= formatReceta($r['od_esfera']) ?></td>
                    <td class="small font-monospace"><?= formatReceta($r['oi_esfera']) ?></td>
                    <td><span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25"><?= clean($r['tipo_lente'] ?? 'N/A') ?></span></td>
                    <td class="text-muted small"><?= clean($r['optometrista_nombre'] ?? '-') ?></td>
                    <td class="text-muted small"><?= formatDate($r['fecha']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a href="<?= BASE_URL ?>/recetas/<?= $r['id'] ?>" class="btn btn-outline-secondary" title="Ver">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?= BASE_URL ?>/recetas/<?= $r['id'] ?>/print" class="btn btn-outline-dark" title="Imprimir" target="_blank">
                                <i class="bi bi-printer"></i>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($recetas)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted py-4">No hay recetas registradas.</td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
