-- ============================================================
-- OptiCore SaaS - Migration 001: New Module Permissions
-- Run after seeds.sql
-- Adds permissions for: categorias, marcas, proveedores,
--   formas_pago, laboratorio, agenda (citas), perfil
-- ============================================================

USE `opticore`;

-- ── Insert new permissions ────────────────────────────────────
INSERT IGNORE INTO `permisos` (`modulo`, `nombre`, `descripcion`) VALUES
-- Categorías
('categorias', 'categorias.ver',      'Ver categorías de productos'),
('categorias', 'categorias.crear',    'Crear categorías'),
('categorias', 'categorias.editar',   'Editar categorías'),
('categorias', 'categorias.eliminar', 'Eliminar/desactivar categorías'),
-- Marcas
('marcas', 'marcas.ver',      'Ver marcas de productos'),
('marcas', 'marcas.crear',    'Crear marcas'),
('marcas', 'marcas.editar',   'Editar marcas'),
('marcas', 'marcas.eliminar', 'Eliminar/desactivar marcas'),
-- Proveedores
('proveedores', 'proveedores.ver',      'Ver proveedores'),
('proveedores', 'proveedores.crear',    'Crear proveedores'),
('proveedores', 'proveedores.editar',   'Editar proveedores'),
('proveedores', 'proveedores.eliminar', 'Eliminar/desactivar proveedores'),
-- Formas de Pago
('formas_pago', 'formas_pago.ver',      'Ver formas de pago'),
('formas_pago', 'formas_pago.crear',    'Crear formas de pago'),
('formas_pago', 'formas_pago.editar',   'Editar formas de pago'),
('formas_pago', 'formas_pago.eliminar', 'Eliminar/desactivar formas de pago'),
-- Laboratorio (ya existía laboratorio.ver/crear/editar en seeds)
-- Agenda / Citas (ya existía citas.ver/crear/editar en seeds)
-- Perfil (acceso propio, no requiere permiso especial)
('perfil', 'perfil.ver',    'Ver perfil propio'),
('perfil', 'perfil.editar', 'Editar perfil propio');

-- ── Assign new permissions to superadmin role (rol_id=1) ──────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 1, id, 1 FROM `permisos`
WHERE `nombre` IN (
  'categorias.ver','categorias.crear','categorias.editar','categorias.eliminar',
  'marcas.ver','marcas.crear','marcas.editar','marcas.eliminar',
  'proveedores.ver','proveedores.crear','proveedores.editar','proveedores.eliminar',
  'formas_pago.ver','formas_pago.crear','formas_pago.editar','formas_pago.eliminar',
  'perfil.ver','perfil.editar'
);

-- ── Assign new permissions to admin_empresa role (rol_id=2) ───
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 2, id, 1 FROM `permisos`
WHERE `nombre` IN (
  'categorias.ver','categorias.crear','categorias.editar','categorias.eliminar',
  'marcas.ver','marcas.crear','marcas.editar','marcas.eliminar',
  'proveedores.ver','proveedores.crear','proveedores.editar','proveedores.eliminar',
  'formas_pago.ver','formas_pago.crear','formas_pago.editar','formas_pago.eliminar',
  'perfil.ver','perfil.editar'
);

-- ── Assign subset to jefe_sucursal role (rol_id=3) ────────────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 3, id, 1 FROM `permisos`
WHERE `nombre` IN (
  'categorias.ver',
  'marcas.ver',
  'proveedores.ver',
  'formas_pago.ver',
  'perfil.ver','perfil.editar'
);

-- ── Assign perfil to all other roles ─────────────────────────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT r.id, p.id, 1
FROM `roles` r
CROSS JOIN `permisos` p
WHERE p.nombre IN ('perfil.ver','perfil.editar')
  AND r.id NOT IN (1,2,3)
ON DUPLICATE KEY UPDATE granted = 1;
