<?php
/**
 * Test directo de Auth::attempt() con bootstrap completo
 */
define('DS', DIRECTORY_SEPARATOR);
require_once dirname(__DIR__) . DS . 'config' . DS . 'config.php';

// Iniciar sesión manualmente para el test
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$email    = 'josuepazmino@gmail.com';
$password = 'natanael1';

echo "=== TEST Auth::attempt() con bootstrap completo ===\n\n";
echo "Email: $email\n";
echo "Password: $password\n\n";

// Capturar cualquier error
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    echo "PHP ERROR [$errno]: $errstr en $errfile:$errline\n";
    return true;
});

try {
    $result = Auth::attempt($email, $password);
    echo "Auth::attempt() retornó: " . ($result ? "TRUE ✓" : "FALSE ✗") . "\n\n";
    
    if ($result) {
        echo "=== SESIÓN CREADA ===\n";
        echo "user.id: " . ($_SESSION['user']['id'] ?? 'N/A') . "\n";
        echo "user.email: " . ($_SESSION['user']['email'] ?? 'N/A') . "\n";
        echo "user.rol_slug: " . ($_SESSION['user']['rol_slug'] ?? 'N/A') . "\n";
        echo "user.es_superadmin: " . (($_SESSION['user']['es_superadmin'] ?? false) ? 'true' : 'false') . "\n";
        echo "permisos count: " . count($_SESSION['user']['permisos'] ?? []) . "\n";
    } else {
        echo "=== DIAGNÓSTICO DE FALLO ===\n";
        // Verificar manualmente cada paso
        $db = db();
        
        $user = $db->fetchOne(
            "SELECT u.*, e.estado as empresa_estado FROM usuarios u
             LEFT JOIN empresas e ON u.empresa_id = e.id
             WHERE u.email = ? AND u.estado = 'activo' LIMIT 1",
            [$email]
        );
        
        if (!$user) {
            echo "✗ Usuario no encontrado o inactivo\n";
        } elseif (!password_verify($password, $user['password'])) {
            echo "✗ password_verify() falló\n";
            echo "  Hash: {$user['password']}\n";
        } elseif (!$user['es_superadmin'] && $user['empresa_estado'] !== 'activa') {
            echo "✗ Empresa inactiva: empresa_estado='{$user['empresa_estado']}'\n";
        } else {
            echo "? Todos los checks pasan pero attempt() retornó false\n";
            echo "  Posible excepción silenciosa en session_regenerate_id() o update()\n";
        }
    }
} catch (Throwable $e) {
    echo "EXCEPCIÓN: " . get_class($e) . ": " . $e->getMessage() . "\n";
    echo "En: " . $e->getFile() . ":" . $e->getLine() . "\n";
    echo "Trace:\n" . $e->getTraceAsString() . "\n";
}

restore_error_handler();
